/*
	game.js
	JavaScript for Classic Memory
	version 1.0 / august 2005
	
	Patrick Machielse (c) 2005
	Hieper Software
*/

//	----------------------------------------------------------------------
//	GAME CLASS
//	----------------------------------------------------------------------
	
function Game()
{
	//	**	ivars
	this.cards = new Array();				//	card array
	this.tries = 0;							//	tries counter
	this.found = 0;							//	found pairs counter
	this.pick  = [null, null];				//	picked cards in a turn
	this.onstatechange = function() {};		//	state change event handler
	
	//	**	methods
	//	create a card from passed img and add it to cards
	this.addCard = function(img) { this.cards.push(new Card(this, img)); }
	
	//	Handle a mouse click on a card
	this.turn = function(card) {
		//	do nothing if the card was already open or its couterpart was found
		if ( card.found || card == this.pick[0] || card == this.pick[1] )
			return;
		
		//	close other open cards if pick[1] exists (== 2 opened)
		if ( this.pick[1] ) {
			this.pick[0].close();
			this.pick[1].close();
			this.pick = [null, null];
		}

		card.open();
		
		//	register opened card
		this.pick[this.pick[0] ? 1 : 0] = card;
		
		//	if open cards match we found a pair
		if ( this.pick[0].matches(this.pick[1]) ) {
			this.found++;
			this.pick[0].found = true;
			this.pick[1].found = true;
			this.pick = [null, null];
		}
		
		this.tries++;
		this.onstatechange(this);
	}
	
	//	Make 'selection': an array of pairs of cards from the cards array
	this.selectCards = function () {
		//	randomly select cards
		var len = this.cards.length;
		var selection = new Array();
		for ( var i = 0; i != len; i+=2 ) {
			//	find new card number
			do {
				var j = rand(Game.ICONS);
			} while ( selection.contains(j) )
			
			//	add it to the selection twice
			selection.push(j, j);
		}
		
		//	suffle selection with 100 swaps
		for ( var i = 0; i != 100; i++ ) {
			selection.swap(rand(len), rand(len));
		}

		//	reset the cards to new selection
		for ( var i = 0; i != len; i++ ) {
			this.cards[i].found	= false;
			this.cards[i].number = selection[i];
			this.cards[i].close();
		}
	}
	
	//	Reset this game
	this.reset = function()	{
		this.pick  = [null, null];
		this.tries = this.found = 0;
		this.selectCards();
		this.onstatechange(this);
	}
	
	//	a 'turn' consists of 2 tries
	this.turns = function () { return parseInt((this.tries + 1) / 2); }
	
	//	a game is solved when all cards are matched
	this.isSolved = function () { return 2 * this.found == this.cards.length; }
	
	//	------------------------------------------------------------------
	//	CARD INNER CLASS
	//	------------------------------------------------------------------

	function Card(game, image)
	{
		var self = this;
		
		//	**	ivars
		this.found	   = false;
		this.number	   = undefined;
		this.image	   = image;
		this.image.src = Card.BACK;
		this.image.onclick = function () { game.turn(self); };
		
		//	**	methods
		//	check if two cards match
		this.matches = function (card) {
			return card && card != this && card.number == this.number;
		}
		
		//	show the card image
		this.open = function () {
			if ( this.number != undefined ) {
				var num	= this.number < 10 ? "0" + this.number : this.number;
				this.image.src = Card.PATH + num + ".png"; 
			}
		}
		
		//	show the back of the card
		this.close = function () { this.image.src = Card.BACK; }
	}
	Card.BACK = CARDBACK;		//	path to back image
	Card.PATH = CARDBASE;		//	path to front images

	//	------------------------------------------------------------------
	//	CROSS PLATFORM GLUE
	//	------------------------------------------------------------------
	
	//	return a random integer in the range [0, max>
	//	matches the K function 'random()' on all JavaScript platforms
	function rand(max) { return Math.floor(Math.random() * max); }
}
Game.ICONS	= 45;		//	# of icons in ./images/cards
Game.CUT	= 30;		//	# of cards in a game